//COMMUNICATING VARIABLES


// This value will store the last time we published an event
long lastPublishedAt = 0;
// this is the time delay before we should publish a new event
// from this device
int publishAfter = 10000;

// VIBRATING VARIABLES
int location1 = D4;
int location2 = D6;


void setup()
{
  Particle.variable("ledStatus",ledStatus);
  Particle.function("led",ledToggle);


  Serial.println("hi");
  // vibrator actions
  pinMode( location1, OUTPUT );
  digitalWrite( location1, LOW);

  pinMode( location2, OUTPUT );
  digitalWrite( location2, LOW);
  // button actions
  Particle.subscribe(  "diot/2018/brello/umbrella_status" , handleSharedEvent);
}


void loop()
{
}
// Our event handlde requires two bits of information
// This gives us:
// A character array that consists of the event name
// A character array that contains the data published in the event we're responding to.
void handleSharedEvent(const char *event, const char *data)
{

  Serial.println("handle event");
    // Now we're getting ALL events published using "db2018/paired/"
    // This includes events from this device.
    // So we need to ignore any events that we sent.
    // Let's check the event name
    String umbrella_status = String( event );
    String update = String( data ); // convert to a string object
    // This gives us access to a bunch of built in methods
    // Like indexOf()
    // Locates a character or String within another String.
    // By default, searches from the beginning of the String,
    // but can also start from a given index,
    // allowing for the locating of all instances of the character or String.
    // It Returns: The index of val within the String, or -1 if not found.
    // We can use this to check if our event name contains the
    // id of this device
    // otherwise do your stuff to respond to
    // the paired device here
    //if we don't get kicked out of the function, go ahead and blink 5 times;

    updateStatus(update);
}

void updateStatus(const char* getData) {

Serial.println(getData);

  if ((String)getData == "returned") {
  digitalWrite( location1, HIGH);
  digitalWrite( location2, LOW);
  Serial.println("RETURNNNNNNED");
  }
  else if ((String)getData == "taken") {
    digitalWrite( location1, LOW);
    digitalWrite( location2, HIGH);

  }

// FUNCTION THAT takes info from rfid scanner and turns
//LED green or blue
// update variable that controls rgb values

}
